<?php
header('Content-Type: application/json');
include 'db.php'; // Include your database connection

$response = ["status" => "error", "message" => "Invalid Request"];

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get JSON input
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    // Validate input
    if (empty($data['addressid'])) {
        $response["message"] = "Address ID is required";
        http_response_code(400);
        echo json_encode($response);
        exit;
    }

    // Sanitize input
    $addressid = mysqli_real_escape_string($conn, $data['addressid']);

    // Check if address exists
    $checkQuery = "SELECT addressid FROM address WHERE addressid = '$addressid' AND Delete_status = 0";
    $checkResult = mysqli_query($conn, $checkQuery);
    
    if (mysqli_num_rows($checkResult) === 0) {
        $response["message"] = "Address not found or already deleted";
        http_response_code(400);
        echo json_encode($response);
        exit;
    }

    // Update Delete_status to 1 (soft delete)
    $updateQuery = "UPDATE address SET Delete_status = 1 WHERE addressid = '$addressid'";
    
    if (mysqli_query($conn, $updateQuery)) {
        $response = ["status" => "success", "message" => "Address deleted successfully"];
    } else {
        $response["message"] = "Failed to delete address: " . mysqli_error($conn);
        http_response_code(500);
    }
} else {
    $response["message"] = "Only POST requests are allowed";
    http_response_code(405);
}

echo json_encode($response);
?>
